<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Line extends Model 
{

    protected $table = 'lines';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_abstraction()
    {
        return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Finance\Currency', 'currency_id');
    }

    public function lineable()
    {
        return $this->morphTo();
    }

    public function listing()
    {
        return $this->belongsTo('App\Models\Listing\Listing', 'listing_id');
    }

}